/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInfoBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.StringUtils;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;

public class DNSBean
extends PanelBean
implements SettingsConstants,
SettingsErrorIds {
    private boolean m_bDnsEnabled;
    private String m_sDnsServer;
    private String m_sDnsServers;
    private ValueDescriptor[] m_cdDnsServers;
    private String m_sDomainSuffix;
    private String m_sDomainSuffixes;
    private ValueDescriptor[] m_cdDomainSuffixes;
    private NetworkInfo _networkInfo;
    private String[] DNS_Entries;
    private String[] suffix_Entries;
    private static final String TRACE_MASKT = "XSETDNST";
    private static final String TRACE_MASKF = "XSETDNSF";
    private static final String TRACE_MASKD = "XSETDNSD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "DNSBean");
    protected LocalizableText invalidValueMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badvalue", null);

    public boolean isDnsEnabled() {
        Trace.trace(TRACE_MASKT, "DNSBean: isDnsEnabled : " + this.m_bDnsEnabled);
        return this.m_bDnsEnabled;
    }

    public void setDnsEnabled(boolean b) throws IllegalUserDataException {
        this.m_bDnsEnabled = b;
        Trace.trace(TRACE_MASKT, "DNSBean: setDnsEnabled : " + this.m_bDnsEnabled);
        if (this.getMountPrefix() != null) {
            Trace.trace(TRACE_MASKT, "DNS value = " + b);
            if (b) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServer", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDNS", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServers", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDNS", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffix", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDomainSuffix", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffixes", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDomainSuffix", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DNSSEARCHLABEL", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DOMAINSUFFIXLABEL", true);
            } else {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServer", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDNS", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DnsServers", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDNS", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffix", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "addDomainSuffix", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DomainSuffixes", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "removeDomainSuffix", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DNSSEARCHLABEL", false);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DOMAINSUFFIXLABEL", false);
            }
        }
    }

    public String getDnsServer() {
        return this.m_sDnsServer;
    }

    public void setDnsServer(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "DNSBean: setDnsServer run: " + s);
        if (!NetworkInfo.isValidIPAddr(s)) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sDnsServer = s;
    }

    public String getDnsServers() {
        Trace.trace(TRACE_MASKT, "DNSBean: getDnsServers()");
        return this.m_sDnsServers;
    }

    public void setDnsServers(String s) throws IllegalUserDataException {
        this.m_sDnsServers = s;
        Trace.trace(TRACE_MASKT, "<> DNSBean.setDnsServers [" + s + "]");
    }

    public ValueDescriptor[] getDnsServersList() {
        if (this.m_cdDnsServers != null) {
            Trace.trace(TRACE_MASKT, "DNSBean: getDnsServersList(), m_cdDnsServers.length = " + this.m_cdDnsServers.length);
            int i = 0;
            while (i < this.m_cdDnsServers.length) {
                Trace.trace(TRACE_MASKT, "ValueDescriptor: getDnsServersList = [" + this.m_cdDnsServers[i].getName() + " , " + this.m_cdDnsServers[i].getTitle() + "]");
                ++i;
            }
        }
        return this.m_cdDnsServers;
    }

    public void setDnsServersList(ValueDescriptor[] items) {
        int i = 0;
        while (i < items.length) {
            Trace.trace(TRACE_MASKT, "ValueDescriptor: getDnsServersList = [" + items[i].getName() + " , " + items[i].getTitle() + "]");
            ++i;
        }
        this.m_cdDnsServers = items;
    }

    public String getDomainSuffix() {
        return this.m_sDomainSuffix;
    }

    public void setDomainSuffix(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "DNSBean: setDomainSuffix run: " + s);
        if (!StringUtils.isValid(s, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.")) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sDomainSuffix = s;
    }

    public String getDomainSuffixes() {
        return this.m_sDomainSuffixes;
    }

    public void setDomainSuffixes(String s) throws IllegalUserDataException {
        this.m_sDomainSuffixes = s;
        Trace.trace(TRACE_MASKT, "<> DNSBean.setDomainSuffixes [" + s + "]");
    }

    public ValueDescriptor[] getDomainSuffixesList() {
        if (this.m_cdDomainSuffixes != null) {
            int i = 0;
            while (i < this.m_cdDomainSuffixes.length) {
                Trace.trace(TRACE_MASKT, "ValueDescriptor: getDomainSuffixesList = [" + this.m_cdDomainSuffixes[i].getName() + " , " + this.m_cdDomainSuffixes[i].getTitle() + "]");
                ++i;
            }
        }
        return this.m_cdDomainSuffixes;
    }

    public void setDomainSuffixesList(ValueDescriptor[] items) {
        this.m_cdDomainSuffixes = items;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.save()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.load()");
    }

    public void panelAction(TaskActionEvent event) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "<- DNSBean.panelAction()" + command);
        Object uiExc = null;
        try {
            String newDomainSuffix;
            String newDnsServer;
            UserTaskManager utm = (UserTaskManager)event.getSource();
            DNSBean beans = this;
            Object[] allBeans = utm.getDataObjects();
            String myBeanName = this.getClass().getName();
            int i = 0;
            while (i < allBeans.length) {
                String beanName = allBeans[i].getClass().getName();
                if (beanName.equals(myBeanName)) {
                    beans = (DNSBean)utm.getDataObjects()[i];
                }
                ++i;
            }
            beans.storeMyElements();
            if (command.endsWith("addDNS")) {
                Trace.trace(TRACE_MASKT, "ADD_DNS_BUTTON pressed!  getDnsServer() = " + this.getDnsServer());
                newDnsServer = this.getDnsServer();
                ValueDescriptor[] vd = this.getDnsServersList();
                Trace.trace(TRACE_MASKT, "newDnsServer.length = " + newDnsServer.length());
                if (newDnsServer.length() != 0) {
                    beans.addToList(vd, newDnsServer, "DNS");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Add; ignore button press");
                }
                beans.setDnsServer("");
            } else if (command.endsWith("removeDNS")) {
                Trace.trace(TRACE_MASKT, "REMOVE_DNS_BUTTON pressed! getDnsServers() = " + this.getDnsServers());
                newDnsServer = beans.getDnsServers();
                ValueDescriptor[] vd = this.getDnsServersList();
                if (vd.length != 0) {
                    beans.deleteRow(vd, newDnsServer, "DNS");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Remove; ignore button press");
                }
            } else if (command.endsWith("addDomainSuffix")) {
                Trace.trace(TRACE_MASKT, "ADD_DOMAINSUFFIX_BUTTON pressed! getDomainSuffix() = " + this.getDomainSuffix());
                newDomainSuffix = this.getDomainSuffix();
                ValueDescriptor[] vd = this.getDomainSuffixesList();
                if (newDomainSuffix.length() != 0) {
                    this.addToList(vd, newDomainSuffix, "DomainSuffix");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Add; ignore button press");
                }
                this.setDomainSuffix("");
            } else if (command.endsWith("removeDomainSuffix")) {
                Trace.trace(TRACE_MASKT, "REMOVE_DOMAINSUFFIX_BUTTON pressed! getDomainSuffixes() = " + this.getDomainSuffixes());
                newDomainSuffix = this.getDomainSuffixes();
                ValueDescriptor[] vd = this.getDomainSuffixesList();
                if (vd.length != 0) {
                    this.deleteRow(vd, newDomainSuffix, "DomainSuffix");
                } else {
                    Trace.trace(TRACE_MASKT, "Nothing to Remove; ignore button press");
                }
            }
            beans.refreshMyElements();
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 16, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- DNSBean.panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> DNSBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("dnspanel");
        if (command.endsWith("okButton") || command.endsWith("applyButton")) {
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (DNSBean) ");
            this._networkInfo.setDNSEnabled(this.isDnsEnabled());
            int num_DNS_Entries = this.m_cdDnsServers.length;
            this.DNS_Entries = new String[num_DNS_Entries];
            int i = 0;
            while (i < num_DNS_Entries) {
                this.DNS_Entries[i] = this.m_cdDnsServers[i].getTitle();
                Trace.trace(TRACE_MASKT, "DNS_Entries[i] = " + this.DNS_Entries[i]);
                ++i;
            }
            int num_Suffix_Entries = this.m_cdDomainSuffixes.length;
            this.suffix_Entries = new String[num_Suffix_Entries];
            int i2 = 0;
            while (i2 < num_Suffix_Entries) {
                this.suffix_Entries[i2] = this.m_cdDomainSuffixes[i2].getTitle();
                Trace.trace(TRACE_MASKT, "suffix_Entries[i] = " + this.suffix_Entries[i2]);
                ++i2;
            }
            this._networkInfo.setDNSServers(this.DNS_Entries);
            this._networkInfo.setDomainSuffixes(this.suffix_Entries);
            request.setData("panel", "dnspanel");
            request.setData("dataupdates", this._networkInfo);
            this.postTaskletRequest(request);
        } else if (command.endsWith("cancelButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (DNSBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            int num_DNS_Entries = this.m_cdDnsServers.length;
            int num_Suffix_Entries = this.m_cdDomainSuffixes.length;
            Trace.trace(TRACE_MASKT, "_networkInfo.isDNSEnabled() = " + this._networkInfo.isDNSEnabled() + "; m_bDnsEnabled = " + this.m_bDnsEnabled);
            Trace.trace(TRACE_MASKT, "_networkInfo.getDNSServers().length = " + this._networkInfo.getDNSServers().length + "; num_DNS_Entries = " + num_DNS_Entries);
            Trace.trace(TRACE_MASKT, "_networkInfo.getDomainSuffixes().length = " + this._networkInfo.getDomainSuffixes().length + "; num_Suffix_Entries = " + num_Suffix_Entries);
            if (this._networkInfo.isDNSEnabled() == this.m_bDnsEnabled && this._networkInfo.getDNSServers().length == num_DNS_Entries && this._networkInfo.getDomainSuffixes().length == num_Suffix_Entries) {
                boolean foundDifferences = false;
                int i = 0;
                while (i < num_DNS_Entries) {
                    if (!this._networkInfo.getDNSServers()[i].equals(this.m_cdDnsServers[i].getTitle()) && !foundDifferences) {
                        Trace.trace(TRACE_MASKT, "_networkInfo.getDNSServers()[i] = [" + this._networkInfo.getDNSServers()[i] + "]");
                        Trace.trace(TRACE_MASKT, "m_cdDnsServers[i].getTitle() = [" + this.m_cdDnsServers[i].getTitle() + "]");
                        foundDifferences = true;
                        ((NetworkInfoBean)parent).setDataChanged();
                        Trace.trace(TRACE_MASKT, "DNSBean believes data has changed");
                    }
                    ++i;
                }
                int i3 = 0;
                while (i3 < num_Suffix_Entries) {
                    if (!this._networkInfo.getDomainSuffixes()[i3].equals(this.m_cdDomainSuffixes[i3].getTitle()) && !foundDifferences) {
                        Trace.trace(TRACE_MASKT, "_networkInfo.getDomainSuffixes()[i] = " + this._networkInfo.getDomainSuffixes()[i3]);
                        Trace.trace(TRACE_MASKT, "m_cdDomainSuffixes[i].getTitle() = " + this.m_cdDomainSuffixes[i3].getTitle());
                        foundDifferences = true;
                        ((NetworkInfoBean)parent).setDataChanged();
                        Trace.trace(TRACE_MASKT, "DNSBean believes data has changed");
                    }
                    ++i3;
                }
            } else {
                ((NetworkInfoBean)parent).setDataChanged();
                Trace.trace(TRACE_MASKT, "DNSBean believes data has changed");
            }
        }
        Trace.trace(TRACE_MASKT, "<- DNSBean.parentalAction()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.prepare()");
        this.setDnsEnabled(this.isDnsEnabled());
        int num_DNS_Entries = this.DNS_Entries.length;
        this.m_cdDnsServers = new ValueDescriptor[num_DNS_Entries];
        int i = 0;
        while (i < num_DNS_Entries) {
            this.m_cdDnsServers[i] = new ValueDescriptor(this.DNS_Entries[i], this.DNS_Entries[i]);
            Trace.trace(TRACE_MASKT, "VDescr prepare: i= [" + i + "];  DNS_Entries[" + i + "] = [" + this.DNS_Entries[i] + "]");
            ++i;
        }
        int num_Suffix_Entries = this.suffix_Entries.length;
        this.m_cdDomainSuffixes = new ValueDescriptor[num_Suffix_Entries];
        int i2 = 0;
        while (i2 < num_Suffix_Entries) {
            this.m_cdDomainSuffixes[i2] = new ValueDescriptor(this.suffix_Entries[i2], this.suffix_Entries[i2]);
            Trace.trace(TRACE_MASKT, "VDescr prepare: i= [" + i2 + "];  suffix_Entries[i] = [" + this.suffix_Entries[i2] + "]");
            ++i2;
        }
        if (num_DNS_Entries > 0) {
            this.setDnsServers(this.DNS_Entries[0]);
        }
        if (num_Suffix_Entries > 0) {
            this.setDomainSuffixes(this.suffix_Entries[0]);
        }
        Trace.trace(TRACE_MASKT, "getDnsServers() = [" + this.getDnsServers() + "]");
        Trace.trace(TRACE_MASKT, "getDomainSuffixes() = [" + this.getDomainSuffixes() + "]");
        Trace.trace(TRACE_MASKT, "<- DNSBean.prepare()");
    }

    private void addToList(ValueDescriptor[] vdList, String newElement, String listType) {
        int numRows = vdList.length;
        Trace.trace(TRACE_MASKT, "numRows = [" + numRows + "]");
        String[] entries = new String[numRows];
        int i = 0;
        while (i < numRows) {
            entries[i] = vdList[i].getTitle();
            ++i;
        }
        vdList = new ValueDescriptor[numRows + 1];
        int i2 = 0;
        i2 = 0;
        while (i2 < numRows) {
            vdList[i2] = new ValueDescriptor(entries[i2], entries[i2]);
            Trace.trace(TRACE_MASKT, "New copy loop: i= [" + i2 + "];\t entries[i] = [" + entries[i2] + "];  entries[i] = [" + entries[i2] + "]");
            ++i2;
        }
        Trace.trace(TRACE_MASKT, "Out of loop now; numRows = [" + numRows + "]");
        vdList[numRows] = new ValueDescriptor(newElement, newElement);
        if (listType.equals("DNS")) {
            Trace.trace(TRACE_MASKT, "DNS List");
            this.setDnsServersList(vdList);
            this.setDnsServers(newElement);
        } else {
            Trace.trace(TRACE_MASKT, "Domain Suffix List");
            this.setDomainSuffixesList(vdList);
            this.setDomainSuffixes(newElement);
        }
    }

    private void deleteRow(ValueDescriptor[] vdList, String listItem, String listType) {
        Trace.trace(TRACE_MASKT, "-> DNSBean.deleteRow, listItem = " + listItem + "; listType = " + listType);
        int numRows = vdList.length;
        Trace.trace(TRACE_MASKT, "number of rows = " + numRows);
        if (numRows < 1) {
            Trace.trace(TRACE_MASKT, "Bail out - the table is empty");
            return;
        }
        String[] entries = new String[numRows];
        int i = 0;
        while (i < numRows) {
            entries[i] = vdList[i].getTitle();
            ++i;
        }
        vdList = new ValueDescriptor[--numRows];
        int j = 0;
        int i2 = 0;
        while (j < numRows) {
            Trace.trace(TRACE_MASKT, "listItem = [" + listItem + "]; entries[i] = " + entries[i2]);
            if (listItem.equals(entries[i2])) {
                ++i2;
            }
            vdList[j] = new ValueDescriptor(entries[i2], entries[i2]);
            Trace.trace(TRACE_MASKT, "numRows = [" + numRows + "]");
            Trace.trace(TRACE_MASKT, "New copy loop: i= [" + i2 + "];\t entries[i] = [" + entries[i2] + "];  entries[j] = [" + entries[j] + "]\n");
            ++j;
            ++i2;
        }
        int listboxLength = vdList.length;
        Trace.trace(TRACE_MASKT, "new vdList.length = " + vdList.length);
        if (listType.equals("DNS")) {
            Trace.trace(TRACE_MASKT, "DNS List");
            this.setDnsServersList(vdList);
            this.m_sDnsServers = listboxLength > 0 ? vdList[listboxLength - 1].getTitle() : "";
        } else {
            Trace.trace(TRACE_MASKT, "Domain Suffix List");
            this.setDomainSuffixesList(vdList);
            if (listboxLength > 0) {
                this.setDomainSuffixes(vdList[listboxLength - 1].getTitle());
            } else {
                this.setDomainSuffixes("");
            }
        }
        Trace.trace(TRACE_MASKT, "<- DNSBean.deleteRow()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DnsEnabled");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DnsServer");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DnsServers");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DomainSuffix");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DomainSuffixes");
        Trace.trace(TRACE_MASKT, "<- DNSBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> DNSBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DnsEnabled");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DnsServer");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DnsServers");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DomainSuffix");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DomainSuffixes");
        Trace.trace(TRACE_MASKT, "<- DNSBean.refreshMyElements()");
    }

    public void setNetworkInfo(NetworkInfo networkInfo) {
        Trace.trace(TRACE_MASKT, "-> DNSBean.setNetworkInfo();  dnsEnabled = " + networkInfo.isDNSEnabled());
        this.setDnsEnabled(networkInfo.isDNSEnabled());
        this.setDnsServer("");
        this.DNS_Entries = networkInfo.getDNSServers();
        this.setDomainSuffix("");
        this.suffix_Entries = networkInfo.getDomainSuffixes();
        this._networkInfo = networkInfo;
        Trace.trace(TRACE_MASKT, "<- DNSBean.setNetworkInfo()");
    }
}

